--[[
This file is a practical introduction to PlayerJoined/Unjoined Messages.
However, with the advent of [ScreenSelectMaster]::DoSwitchAnyways, it's a bit
unnecessary. I've left this in here for informational purposes. -aj
]]

local t = Def.ActorFrame{};

-- bubble positions follow credits like in mockup
local yOffset = 50;

local positionP1 = {
	X = THEME:GetMetric( "ScreenSystemLayer","CreditsP1X" ),
	Y = THEME:GetMetric( "ScreenSystemLayer","CreditsP1Y" ) - yOffset,
};
local positionP2 = {
	X = THEME:GetMetric( "ScreenSystemLayer","CreditsP2X" ),
	Y = THEME:GetMetric( "ScreenSystemLayer","CreditsP2Y" ) - yOffset,
};

local function MakeBubble(pn)
	local initcmd;

	if pn == PLAYER_1 then initcmd = cmd(x,positionP1.X;y,positionP1.Y);
	elseif pn == PLAYER_2 then initcmd = cmd(x,positionP2.X;y,positionP2.Y);
	end;

	return LoadActor( THEME:GetPathG("","_common/joinbubble") )..{
		Name="JoinBubble"..pn;
		InitCommand=initcmd;
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(pn) then self:diffusealpha(0);
			else self:diffusealpha(1);
			end;
		end;
		OffCommand=cmd(linear,0.25;diffusealpha,0);
		PlayerJoinedMessageCommand=function(self,params)
			if params.Player == pn then
				self:accelerate(0.3);
				self:diffusealpha(0);
				self:zoom(1.3);
			end;
		end;
		PlayerUnjoinedMessageCommand=function(self,params)
			if params.Player == pn then
				self:linear(0.5);
				self:diffusealpha(1);
			end;
		end;
	};
end;

--[[
t[#t+1] = MakeBubble(PLAYER_1);
t[#t+1] = MakeBubble(PLAYER_2);

-- sneaky bastard move: if two players are joined,
-- move to the next screen automatically. This doesn't exactly work since it
-- requires a style to be set.
t[#t+1] = Def.Actor{
	Name="SneakyJerkController";
	PlayerJoinedMessageCommand=function(self,params)
		if GAMESTATE:GetNumPlayersEnabled() > 1 then
			--SCREENMAN:GetTopScreen():PostScreenMessage("SM_GoToNextScreen",0.8);
		end;
	end;
};
--]]

return t;